<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use stdClass;

/**
 * The tracking details of an order.
 */
class OrderTrackerRequest implements \JsonSerializable
{
    /**
     * @var string|null
     */
    private $trackingNumber;

    /**
     * @var string|null
     */
    private $carrier;

    /**
     * @var string|null
     */
    private $carrierNameOther;

    /**
     * @var string
     */
    private $captureId;

    /**
     * @var bool|null
     */
    private $notifyPayer = false;

    /**
     * @var OrderTrackerItem[]|null
     */
    private $items;

    /**
     * @param string $captureId
     */
    public function __construct(string $captureId)
    {
        $this->captureId = $captureId;
    }

    /**
     * Returns Tracking Number.
     * The tracking number for the shipment. This property supports Unicode.
     */
    public function getTrackingNumber(): ?string
    {
        return $this->trackingNumber;
    }

    /**
     * Sets Tracking Number.
     * The tracking number for the shipment. This property supports Unicode.
     *
     * @maps tracking_number
     */
    public function setTrackingNumber(?string $trackingNumber): void
    {
        $this->trackingNumber = $trackingNumber;
    }

    /**
     * Returns Carrier.
     * The carrier for the shipment. Some carriers have a global version as well as local subsidiaries. The
     * subsidiaries are repeated over many countries and might also have an entry in the global list.
     * Choose the carrier for your country. If the carrier is not available for your country, choose the
     * global version of the carrier. If your carrier name is not in the list, set `carrier` to `OTHER` and
     * set carrier name in `carrier_name_other`. For allowed values, see <a
     * href="/docs/tracking/reference/carriers/">Carriers</a>.
     */
    public function getCarrier(): ?string
    {
        return $this->carrier;
    }

    /**
     * Sets Carrier.
     * The carrier for the shipment. Some carriers have a global version as well as local subsidiaries. The
     * subsidiaries are repeated over many countries and might also have an entry in the global list.
     * Choose the carrier for your country. If the carrier is not available for your country, choose the
     * global version of the carrier. If your carrier name is not in the list, set `carrier` to `OTHER` and
     * set carrier name in `carrier_name_other`. For allowed values, see <a
     * href="/docs/tracking/reference/carriers/">Carriers</a>.
     *
     * @maps carrier
     */
    public function setCarrier(?string $carrier): void
    {
        $this->carrier = $carrier;
    }

    /**
     * Returns Carrier Name Other.
     * The name of the carrier for the shipment. Provide this value only if the carrier parameter is OTHER.
     * This property supports Unicode.
     */
    public function getCarrierNameOther(): ?string
    {
        return $this->carrierNameOther;
    }

    /**
     * Sets Carrier Name Other.
     * The name of the carrier for the shipment. Provide this value only if the carrier parameter is OTHER.
     * This property supports Unicode.
     *
     * @maps carrier_name_other
     */
    public function setCarrierNameOther(?string $carrierNameOther): void
    {
        $this->carrierNameOther = $carrierNameOther;
    }

    /**
     * Returns Capture Id.
     * The PayPal capture ID.
     */
    public function getCaptureId(): string
    {
        return $this->captureId;
    }

    /**
     * Sets Capture Id.
     * The PayPal capture ID.
     *
     * @required
     * @maps capture_id
     */
    public function setCaptureId(string $captureId): void
    {
        $this->captureId = $captureId;
    }

    /**
     * Returns Notify Payer.
     * If true, sends an email notification to the payer of the PayPal transaction. The email contains the
     * tracking information that was uploaded through the API.
     */
    public function getNotifyPayer(): ?bool
    {
        return $this->notifyPayer;
    }

    /**
     * Sets Notify Payer.
     * If true, sends an email notification to the payer of the PayPal transaction. The email contains the
     * tracking information that was uploaded through the API.
     *
     * @maps notify_payer
     */
    public function setNotifyPayer(?bool $notifyPayer): void
    {
        $this->notifyPayer = $notifyPayer;
    }

    /**
     * Returns Items.
     * An array of details of items in the shipment.
     *
     * @return OrderTrackerItem[]|null
     */
    public function getItems(): ?array
    {
        return $this->items;
    }

    /**
     * Sets Items.
     * An array of details of items in the shipment.
     *
     * @maps items
     *
     * @param OrderTrackerItem[]|null $items
     */
    public function setItems(?array $items): void
    {
        $this->items = $items;
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->trackingNumber)) {
            $json['tracking_number']    = $this->trackingNumber;
        }
        if (isset($this->carrier)) {
            $json['carrier']            = ShipmentCarrier::checkValue($this->carrier);
        }
        if (isset($this->carrierNameOther)) {
            $json['carrier_name_other'] = $this->carrierNameOther;
        }
        $json['capture_id']             = $this->captureId;
        if (isset($this->notifyPayer)) {
            $json['notify_payer']       = $this->notifyPayer;
        }
        if (isset($this->items)) {
            $json['items']              = $this->items;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
