<?php

    namespace App\Http\Controllers\Debug;

    use App\Http\Controllers\Controller;
    use App\Models\Campaigns;
    use App\Models\ContactGroups;
    use App\Models\Contacts;
    use App\Models\PaymentMethods;
    use Illuminate\Support\Facades\Cache;
    use Illuminate\Support\Facades\DB;
    use libphonenumber\NumberParseException;
    use libphonenumber\PhoneNumberUtil;

    class DebugController extends Controller
    {
        public function index()
        {
            // Set total_amount equal to the updated amount
            DB::table('invoices')->update([
                'total_amount' => DB::raw('amount'),
            ]);

            DB::table('invoices')->update([
                'amount' => DB::raw('amount - tax'),
            ]);

            return redirect()->route('admin.invoices.index')->with([
                'status'  => 'success',
                'message' => 'Invoices updated successfully',
            ]);
        }

        public function removeJobs()
        {
            DB::table('job_monitors')->truncate();
            DB::table('job_batches')->truncate();
            DB::table('jobs')->truncate();
            DB::table('import_job_histories')->truncate();
            DB::table('failed_jobs')->truncate();

            return 'Job cleared successfully';
        }

        public function addGateways()
        {
            $check_exist = PaymentMethods::where('type', 'myFatoorah')->first();
            if ( ! $check_exist) {
                $data = PaymentMethods::create(

                    [
                        'name'    => PaymentMethods::TYPE_NOWPAYMENTS,
                        'type'    => PaymentMethods::TYPE_NOWPAYMENTS,
                        'options' => json_encode([
                            'payment_url'    => 'https://api.nowpayments.io/v1/',
                            'api_key'        => 'F6ZXWAY-2K7MQ6K-G0GWJH8-AK3RT1K',
                            'public_key'     => '908f2f2b-eda0-4210-a1b3-9d8c1b0bcfc7',
                            'ipn_secret_key' => 'lnbcIgz7iA/cOjh/K6mqn5lz+JfO0Kjj',
                        ]),
                        'status'  => false,
                    ],
                );
                if ($data) {
                    return redirect()->route('admin.payment-gateways.show', $data->uid)->with([
                        'status'  => 'success',
                        'message' => 'Gateway was successfully Added',
                    ]);
                }

                return redirect()->route('login')->with([
                    'status'  => 'error',
                    'message' => __('locale.exceptions.something_went_wrong'),
                ]);

            }

            return 'Gateway already exists';
        }


        public function removeContacts()
        {
            Contacts::chunk(1000, function ($contacts) {
                foreach ($contacts as $contact) {
                    try {

                        $phoneUtil         = PhoneNumberUtil::getInstance();
                        $phoneNumberObject = $phoneUtil->parse('+' . $contact->phone);
                        $countryCode       = $phoneNumberObject->getCountryCode();
                        $isoCode           = $phoneUtil->getRegionCodeForNumber($phoneNumberObject);

                        if ( ! $phoneUtil->isPossibleNumber($phoneNumberObject) || empty($countryCode) || empty($isoCode)) {
                            $contact->delete();
                        }
                    } catch (NumberParseException) {
                        $contact->delete();
                    }
                }
            });

            ContactGroups::chunk(100, function ($contactGroups) {
                foreach ($contactGroups as $contactGroup) {
                    $contactGroup->updateCache();
                }
            });

            return 'Unwanted contacts removed successfully';

        }

        public function cacheClear()
        {

            Cache::flush();

            return 'Cache was cleared successfully';
        }

        public function updateCampaignCache($campaign, $number)
        {
            $campaign = Campaigns::where('uid', $campaign)->first();
            if ($campaign) {
                $data                 = json_decode($campaign->cache, true);
                $data['ContactCount'] = $number;
                $campaign->cache      = json_encode($data);
                $campaign->setDone();
                $campaign->delivery_at = now();
                $campaign->save();

                return 'Cache was updated successfully';

            }

            return 'Campaign not found';
        }

    }
