(function () {
  let $, SmsCounter;

  window.SmsCounter = SmsCounter = (function () {
    function SmsCounter() {}

    SmsCounter.gsm7bitChars =
      "@£$¥èéùìòÇ\nØø\rÅåΔ_ΦΓΛΩΠΨΣΘΞÆæßÉ !\"#¤%&'()*+,-./0123456789:;<=>?¡" +
      "ABCDEFGHIJKLMNOPQRSTUVWXYZÄÖÑÜ§¿abcdefghijklmnopqrstuvwxyzäöñüà";

    SmsCounter.gsm7bitExChar = "^{}\\[~]|€";

    SmsCounter.gsm7bitRegExp = RegExp("^[" + SmsCounter.gsm7bitChars + "]*$");
    SmsCounter.gsm7bitExRegExp = RegExp(
      "^[" + SmsCounter.gsm7bitChars + SmsCounter.gsm7bitExChar + "]*$",
    );
    SmsCounter.gsm7bitExOnlyRegExp = RegExp(
      "^[" + SmsCounter.gsm7bitExChar + "]*$",
    );

    SmsCounter.GSM_7BIT = "GSM_7BIT";
    SmsCounter.GSM_7BIT_EX = "GSM_7BIT_EX";
    SmsCounter.UTF16 = "UTF16";
    SmsCounter.WhatsApp = "WHATSAPP";

    SmsCounter.messageLength = {
      GSM_7BIT: 160,
      GSM_7BIT_EX: 160,
      UTF16: 70,
      WHATSAPP: 1000,
    };

    SmsCounter.multiMessageLength = {
      GSM_7BIT: 153,
      GSM_7BIT_EX: 153,
      UTF16: 67,
      WHATSAPP: 1000,
    };

    SmsCounter.count = function (text, type = "GSM_7BIT") {
      let encoding,
        length = 0,
        messages,
        per_message,
        remaining;

      if (type === "WHATSAPP") {
        encoding = "WHATSAPP";
      } else {
        encoding = this.detectEncoding(text);
      }

      // Count each character, handling extended ones properly
      for (let i = 0; i < text.length; i++) {
        const char = text[i];
        if (
          encoding === this.GSM_7BIT_EX &&
          SmsCounter.gsm7bitExChar.includes(char)
        ) {
          length += 2; // extended character uses two septets
        } else {
          length += 1;
        }
      }

      per_message = this.messageLength[encoding];
      if (length > per_message) {
        per_message = this.multiMessageLength[encoding];
      }

      messages = Math.ceil(length / per_message);
      remaining = per_message * messages - length;
      if (remaining === 0 && messages === 0) {
        remaining = per_message;
      }

      return {
        encoding: encoding,
        length: length,
        per_message: per_message,
        remaining: remaining,
        messages: messages,
      };
    };

    SmsCounter.detectEncoding = function (text) {
      if (text.match(this.gsm7bitRegExp)) {
        return this.GSM_7BIT;
      } else if (text.match(this.gsm7bitExRegExp)) {
        return this.GSM_7BIT_EX;
      } else {
        return this.UTF16;
      }
    };

    SmsCounter.countGsm7bitEx = function (text) {
      let count = 0;
      for (let i = 0; i < text.length; i++) {
        const char = text[i];
        if (this.gsm7bitExChar.includes(char)) {
          count++;
        }
      }
      return count;
    };

    return SmsCounter;
  })();

  if (typeof jQuery !== "undefined" && jQuery !== null) {
    $ = jQuery;
    $.fn.countSms = function (target) {
      let count_sms, input;
      input = this;
      target = $(target);
      count_sms = function () {
        let count = SmsCounter.count(input.val());
        for (let k in count) {
          let v = count[k];
          target.find("." + k).text(v);
        }
      };
      this.on("keyup change input", count_sms);
      return count_sms();
    };
  }
}).call(this);
