<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\Item;
use PaypalServerSdkLib\Models\Money;
use PaypalServerSdkLib\Models\UniversalProductCode;

/**
 * Builder for model Item
 *
 * @see Item
 */
class ItemBuilder
{
    /**
     * @var Item
     */
    private $instance;

    private function __construct(Item $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new item Builder object.
     */
    public static function init(string $name, Money $unitAmount, string $quantity): self
    {
        return new self(new Item($name, $unitAmount, $quantity));
    }

    /**
     * Sets tax field.
     */
    public function tax(?Money $value): self
    {
        $this->instance->setTax($value);
        return $this;
    }

    /**
     * Sets description field.
     */
    public function description(?string $value): self
    {
        $this->instance->setDescription($value);
        return $this;
    }

    /**
     * Sets sku field.
     */
    public function sku(?string $value): self
    {
        $this->instance->setSku($value);
        return $this;
    }

    /**
     * Sets url field.
     */
    public function url(?string $value): self
    {
        $this->instance->setUrl($value);
        return $this;
    }

    /**
     * Sets category field.
     */
    public function category(?string $value): self
    {
        $this->instance->setCategory($value);
        return $this;
    }

    /**
     * Sets image url field.
     */
    public function imageUrl(?string $value): self
    {
        $this->instance->setImageUrl($value);
        return $this;
    }

    /**
     * Sets upc field.
     */
    public function upc(?UniversalProductCode $value): self
    {
        $this->instance->setUpc($value);
        return $this;
    }

    /**
     * Initializes a new item object.
     */
    public function build(): Item
    {
        return CoreHelper::clone($this->instance);
    }
}
