<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\OrderTrackerItem;
use PaypalServerSdkLib\Models\UniversalProductCode;

/**
 * Builder for model OrderTrackerItem
 *
 * @see OrderTrackerItem
 */
class OrderTrackerItemBuilder
{
    /**
     * @var OrderTrackerItem
     */
    private $instance;

    private function __construct(OrderTrackerItem $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new order tracker item Builder object.
     */
    public static function init(): self
    {
        return new self(new OrderTrackerItem());
    }

    /**
     * Sets name field.
     */
    public function name(?string $value): self
    {
        $this->instance->setName($value);
        return $this;
    }

    /**
     * Sets quantity field.
     */
    public function quantity(?string $value): self
    {
        $this->instance->setQuantity($value);
        return $this;
    }

    /**
     * Sets sku field.
     */
    public function sku(?string $value): self
    {
        $this->instance->setSku($value);
        return $this;
    }

    /**
     * Sets url field.
     */
    public function url(?string $value): self
    {
        $this->instance->setUrl($value);
        return $this;
    }

    /**
     * Sets image url field.
     */
    public function imageUrl(?string $value): self
    {
        $this->instance->setImageUrl($value);
        return $this;
    }

    /**
     * Sets upc field.
     */
    public function upc(?UniversalProductCode $value): self
    {
        $this->instance->setUpc($value);
        return $this;
    }

    /**
     * Initializes a new order tracker item object.
     */
    public function build(): OrderTrackerItem
    {
        return CoreHelper::clone($this->instance);
    }
}
