<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\Money;
use PaypalServerSdkLib\Models\ShippingOption;

/**
 * Builder for model ShippingOption
 *
 * @see ShippingOption
 */
class ShippingOptionBuilder
{
    /**
     * @var ShippingOption
     */
    private $instance;

    private function __construct(ShippingOption $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new shipping option Builder object.
     */
    public static function init(string $id, string $label, bool $selected): self
    {
        return new self(new ShippingOption($id, $label, $selected));
    }

    /**
     * Sets type field.
     */
    public function type(?string $value): self
    {
        $this->instance->setType($value);
        return $this;
    }

    /**
     * Sets amount field.
     */
    public function amount(?Money $value): self
    {
        $this->instance->setAmount($value);
        return $this;
    }

    /**
     * Initializes a new shipping option object.
     */
    public function build(): ShippingOption
    {
        return CoreHelper::clone($this->instance);
    }
}
